  // Key generation constants

#define ERROR_UNKNOWN                       0xFFFFFFFF
#define ERROR_OK                            0x00000000
#define ERROR_KEY_BUFFER_NOT_ALLOCATED      0x00000001
#define ERROR_KEY_BUFFER_LESS               0x00000002
#define ERROR_REGINFO_BUFFER_NOT_ALLOCATED  0x00000003
#define ERROR_REGINFO_BUFFER_EMPTY          0x00000004
#define ERROR_HARDWARE_TYPE_UNKNOWN         0x00000005
#define ERROR_HARDWARE_ID                   0x00000006
#define ERROR_HARDWARE_BUFFER_NOT_ALLOCATED 0x00000007
#define ERROR_HARDWARE_BUFFER_EMPTY         0x00000008
#define ERROR_INVALID_CONSTANT_D            0x00000009
#define ERROR_INVALID_CONSTANT_N            0x0000000A
#define ERROR_INVALID_CONSTANT_A            0x0000000B
#define ERROR_INVALID_CONSTANT_B            0x0000000C
#define ERROR_PROJECT_FILE_NOT_FOUND        0x0000000D
#define ERROR_PROJECT_FILE_INVALID          0x0000000E
#define ERROR_INVALID_CONSTANT_E            0x0000000F
#define ERROR_INVALID_KEYTYPE               0x00000010
#define ERROR_INVALID_REGINFO               0x00000011

// Hardware locking type constants
#define HID_ERROR           0
#define HID_HARDDISK        1
#define HID_VOLUMENAME      2
#define HID_CPUTYPE         4
#define HID_COMPUTERNAME    8
#define HID_MOTHERBOARDBIOS 16
#define HID_WINDOWSSERIAL   32
#define HID_HDDSERIAL       64

  // Number of crypted sections
#define NUMBER_OF_CRYPTED_SECTIONS          16

  // Key type
#define KEY_TYPE_LONG          0
#define KEY_TYPE_SHORT          1

  // Key format
#define KEY_FORMAT_10          10
#define KEY_FORMAT_16          16
#define KEY_FORMAT_32          32
#define KEY_FORMAT_64          64

typedef struct _GenKeyParams
{
  BYTE KeyType;
  BYTE KeyFormat;
  WORD Reserved3;
  char* Key;                // Key buffer
  DWORD KeyLen;             // Key buffer length
  char* RegInfo;            // User info buffer
  DWORD RegInfoLen;         // User info buffer length
  BYTE  UseKeyExpiration;
  BYTE  Reserved1;
  WORD  ExpirationYear;     // ***
  BYTE  ExpirationMonth;    // *** Key expiration date
  BYTE  ExpirationDay;      // ***
  BYTE  UseHardwareLocking;
  BYTE  Reserved2;
  char* HardwareID;         // Hardware locking info
  BYTE EncryptedSections[NUMBER_OF_CRYPTED_SECTIONS];
  char* D;
  char* N;
  char* A;
  char* B;
} GenKeyParams, *PKeyParams;

typedef struct _TVerifyKey
{
  char* Key;
  BYTE KeyType;
  BYTE KeyFormat;
  WORD Reserved1;
  char* RegInfo;
  BYTE CreateDay;
  BYTE CreateMonth;
  WORD CreateYear;
  BYTE UseKeyExpiration;
  BYTE Reserved2;
  WORD ExpirationYear;
  BYTE ExpirationMonth;
  BYTE ExpirationDay;
  BYTE UseHardwareLocking;
  BYTE HardwareIDType;
  char* HardwareID;
  BYTE EncryptedSections[NUMBER_OF_CRYPTED_SECTIONS];
  char* N;
  char* E;
  char* B;
  char* A;
} TVerifyKey, *PVerifyKey; 

extern "C"
{
  int __declspec(dllimport) __stdcall KG_GenerateRegistrationKey(PKeyParams p);
  int __declspec(dllimport) __stdcall KG_GenerateRegistrationKeyFromProject(char* FileName, PKeyParams p);
  int __declspec(dllimport) __stdcall KG_VerifyRegistrationInfo(PVerifyKey p);
  int __declspec(dllimport) __stdcall KG_VerifyRegistrationInfoFromProject(char* FileName, PVerifyKey p);
}
